/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config;

import com.google.common.collect.Lists;
import com.google.gson.annotations.Expose;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1306;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JadeCodecs;
import snownee.jade.util.ModIdentification;

public class WailaConfig
implements IWailaConfig {
    public static final Codec<WailaConfig> CODEC = RecordCodecBuilder.create(i -> i.group((App)ConfigGeneral.CODEC.fieldOf("general").orElseGet(() -> JadeCodecs.createFromEmptyMap(ConfigGeneral.CODEC)).forGetter(WailaConfig::getGeneral), (App)ConfigOverlay.CODEC.fieldOf("overlay").orElseGet(() -> JadeCodecs.createFromEmptyMap(ConfigOverlay.CODEC)).forGetter(WailaConfig::getOverlay), (App)ConfigFormatting.CODEC.fieldOf("formatting").orElseGet(() -> JadeCodecs.createFromEmptyMap(ConfigFormatting.CODEC)).forGetter(WailaConfig::getFormatting)).apply((Applicative)i, WailaConfig::new));
    private final ConfigGeneral general;
    private final ConfigOverlay overlay;
    private final ConfigFormatting formatting;

    public WailaConfig(ConfigGeneral general, ConfigOverlay overlay, ConfigFormatting formatting) {
        this.general = general;
        this.overlay = overlay;
        this.formatting = formatting;
    }

    @Override
    public ConfigGeneral getGeneral() {
        return this.general;
    }

    @Override
    public ConfigOverlay getOverlay() {
        return this.overlay;
    }

    @Override
    public ConfigFormatting getFormatting() {
        return this.formatting;
    }

    @Override
    public IPluginConfig getPlugin() {
        return PluginConfig.INSTANCE;
    }

    public static class ConfigGeneral
    implements IWailaConfig.IConfigGeneral {
        public static final Codec<ConfigGeneral> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("hintOverlayToggle").orElse((Object)true).forGetter(it -> it.hintOverlayToggle), (App)Codec.BOOL.fieldOf("hintNarratorToggle").orElse((Object)true).forGetter(it -> it.hintNarratorToggle), (App)Codec.BOOL.fieldOf("previewOverlay").orElse((Object)true).forGetter($ -> $.previewOverlay), (App)ConfigDisplay.CODEC.orElse((Object)new ConfigDisplay()).forGetter($ -> $.configDisplay), (App)Codec.BOOL.fieldOf("hideFromDebug").orElse((Object)true).forGetter(ConfigGeneral::shouldHideFromDebug), (App)Codec.BOOL.fieldOf("hideFromTabList").orElse((Object)true).forGetter(ConfigGeneral::shouldHideFromTabList), (App)Codec.BOOL.fieldOf("enableTextToSpeech").orElse((Object)false).forGetter(ConfigGeneral::shouldEnableTextToSpeech), (App)class_3542.method_28140(IWailaConfig.TTSMode::values).fieldOf("ttsMode").orElse((Object)IWailaConfig.TTSMode.PRESS).forGetter(ConfigGeneral::getTTSMode), (App)class_3542.method_28140(IWailaConfig.FluidMode::values).fieldOf("fluidMode").orElse((Object)IWailaConfig.FluidMode.ANY).forGetter(ConfigGeneral::getDisplayFluids), (App)Codec.floatRange((float)0.0f, (float)20.0f).fieldOf("reachDistance").orElse((Object)Float.valueOf(0.0f)).forGetter(ConfigGeneral::getReachDistance), (App)Codec.BOOL.fieldOf("debug").orElse((Object)false).forGetter(ConfigGeneral::isDebug), (App)Codec.BOOL.fieldOf("itemModNameTooltip").orElse((Object)true).forGetter(ConfigGeneral::showItemModNameTooltip), (App)class_3542.method_28140(IWailaConfig.BossBarOverlapMode::values).fieldOf("bossBarOverlapMode").orElse((Object)IWailaConfig.BossBarOverlapMode.PUSH_DOWN).forGetter(ConfigGeneral::getBossBarOverlapMode), (App)Codec.BOOL.fieldOf("builtinCamouflage").orElse((Object)true).forGetter(ConfigGeneral::getBuiltinCamouflage)).apply((Applicative)i, ConfigGeneral::new));
        public static final List<String> itemModNameTooltipDisabledByMods = Lists.newArrayList((Object[])new String[]{"emi"});
        public boolean hintOverlayToggle = true;
        public boolean hintNarratorToggle = true;
        public boolean previewOverlay = true;
        private ConfigDisplay configDisplay = new ConfigDisplay();
        private boolean hideFromDebug = true;
        private boolean hideFromTabList = true;
        private boolean enableTextToSpeech = false;
        private IWailaConfig.TTSMode ttsMode = IWailaConfig.TTSMode.PRESS;
        private IWailaConfig.FluidMode fluidMode = IWailaConfig.FluidMode.ANY;
        private float reachDistance = 0.0f;
        @Expose
        private boolean debug = false;
        private boolean itemModNameTooltip = true;
        private IWailaConfig.BossBarOverlapMode bossBarOverlapMode = IWailaConfig.BossBarOverlapMode.PUSH_DOWN;
        private boolean builtinCamouflage = true;

        public ConfigGeneral(boolean hintOverlayToggle, boolean hintNarratorToggle, boolean previewOverlay, ConfigDisplay configDisplay, boolean hideFromDebug, boolean hideFromTabList, boolean enableTextToSpeech, IWailaConfig.TTSMode ttsMode, IWailaConfig.FluidMode fluidMode, float reachDistance, boolean debug, boolean itemModNameTooltip, IWailaConfig.BossBarOverlapMode bossBarOverlapMode, boolean builtinCamouflage) {
            this.hintOverlayToggle = hintOverlayToggle;
            this.hintNarratorToggle = hintNarratorToggle;
            this.previewOverlay = previewOverlay;
            this.configDisplay = configDisplay;
            this.hideFromDebug = hideFromDebug;
            this.hideFromTabList = hideFromTabList;
            this.enableTextToSpeech = enableTextToSpeech;
            this.ttsMode = ttsMode;
            this.fluidMode = fluidMode;
            this.reachDistance = reachDistance;
            this.debug = debug;
            this.itemModNameTooltip = itemModNameTooltip;
            this.bossBarOverlapMode = bossBarOverlapMode;
            this.builtinCamouflage = builtinCamouflage;
        }

        public ConfigGeneral() {
        }

        public static void init() {
            List<String> names = itemModNameTooltipDisabledByMods.stream().filter(CommonProxy::isModLoaded).map($ -> ModIdentification.getModName($).orElse((String)$)).toList();
            itemModNameTooltipDisabledByMods.clear();
            itemModNameTooltipDisabledByMods.addAll(names);
        }

        @Override
        public void setHideFromDebug(boolean hideFromDebug) {
            this.hideFromDebug = hideFromDebug;
        }

        @Override
        public void toggleTTS() {
            this.enableTextToSpeech = !this.enableTextToSpeech;
        }

        @Override
        public boolean shouldDisplayTooltip() {
            return this.configDisplay.shouldDisplayTooltip();
        }

        @Override
        public void setDisplayTooltip(boolean displayTooltip) {
            this.configDisplay.setDisplayTooltip(displayTooltip);
        }

        @Override
        public boolean getDisplayBlocks() {
            return this.configDisplay.getDisplayBlocks();
        }

        @Override
        public void setDisplayBlocks(boolean displayBlocks) {
            this.configDisplay.setDisplayBlocks(displayBlocks);
        }

        @Override
        public boolean getDisplayEntities() {
            return this.configDisplay.getDisplayEntities();
        }

        @Override
        public void setDisplayEntities(boolean displayEntities) {
            this.configDisplay.setDisplayEntities(displayEntities);
        }

        @Override
        public boolean getDisplayBosses() {
            return this.configDisplay.getDisplayBosses();
        }

        @Override
        public void setDisplayBosses(boolean displayBosses) {
            this.configDisplay.setDisplayBosses(displayBosses);
        }

        @Override
        public IWailaConfig.DisplayMode getDisplayMode() {
            return this.configDisplay.getDisplayMode();
        }

        @Override
        public void setDisplayMode(IWailaConfig.DisplayMode displayMode) {
            this.configDisplay.setDisplayMode(displayMode);
        }

        @Override
        public boolean shouldHideFromDebug() {
            return this.hideFromDebug;
        }

        @Override
        public boolean shouldEnableTextToSpeech() {
            return this.ttsMode == IWailaConfig.TTSMode.TOGGLE && this.enableTextToSpeech;
        }

        @Override
        public IWailaConfig.TTSMode getTTSMode() {
            return this.ttsMode;
        }

        @Override
        public void setTTSMode(IWailaConfig.TTSMode ttsMode) {
            this.ttsMode = ttsMode;
        }

        @Override
        public boolean shouldDisplayFluids() {
            return this.fluidMode != IWailaConfig.FluidMode.NONE;
        }

        @Override
        public IWailaConfig.FluidMode getDisplayFluids() {
            return this.fluidMode;
        }

        @Override
        public void setDisplayFluids(boolean displayFluids) {
            this.fluidMode = displayFluids ? IWailaConfig.FluidMode.ANY : IWailaConfig.FluidMode.NONE;
        }

        @Override
        public void setDisplayFluids(IWailaConfig.FluidMode displayFluids) {
            this.fluidMode = displayFluids;
        }

        @Override
        public float getReachDistance() {
            return this.reachDistance;
        }

        @Override
        public void setReachDistance(float reachDistance) {
            this.reachDistance = class_3532.method_15363((float)reachDistance, (float)0.0f, (float)20.0f);
        }

        @Override
        public boolean isDebug() {
            return this.debug;
        }

        @Override
        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        @Override
        public void setItemModNameTooltip(boolean itemModNameTooltip) {
            this.itemModNameTooltip = itemModNameTooltip;
        }

        @Override
        public boolean showItemModNameTooltip() {
            return this.itemModNameTooltip && itemModNameTooltipDisabledByMods.isEmpty();
        }

        @Override
        public IWailaConfig.BossBarOverlapMode getBossBarOverlapMode() {
            return this.bossBarOverlapMode;
        }

        @Override
        public void setBossBarOverlapMode(IWailaConfig.BossBarOverlapMode mode) {
            this.bossBarOverlapMode = mode;
        }

        @Override
        public void setHideFromTabList(boolean hideFromTabList) {
            this.hideFromTabList = hideFromTabList;
        }

        @Override
        public boolean shouldHideFromTabList() {
            return this.hideFromTabList;
        }

        @Override
        public boolean getBuiltinCamouflage() {
            return this.builtinCamouflage;
        }

        @Override
        public void setBuiltinCamouflage(boolean builtinCamouflage) {
            this.builtinCamouflage = builtinCamouflage;
        }

        private static class ConfigDisplay {
            public static final MapCodec<ConfigDisplay> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.fieldOf("displayTooltip").orElse((Object)true).forGetter(ConfigDisplay::shouldDisplayTooltip), (App)Codec.BOOL.fieldOf("displayBlocks").orElse((Object)true).forGetter(ConfigDisplay::getDisplayBlocks), (App)Codec.BOOL.fieldOf("displayEntities").orElse((Object)true).forGetter(ConfigDisplay::getDisplayEntities), (App)Codec.BOOL.fieldOf("displayBosses").orElse((Object)true).forGetter(ConfigDisplay::getDisplayBosses), (App)class_3542.method_28140(IWailaConfig.DisplayMode::values).fieldOf("displayMode").orElse((Object)IWailaConfig.DisplayMode.TOGGLE).forGetter(ConfigDisplay::getDisplayMode)).apply((Applicative)i, ConfigDisplay::new));
            private boolean displayTooltip = true;
            private boolean displayBlocks = true;
            private boolean displayEntities = true;
            private boolean displayBosses = true;
            private IWailaConfig.DisplayMode displayMode = IWailaConfig.DisplayMode.TOGGLE;

            public ConfigDisplay(boolean displayTooltip, boolean displayBlocks, boolean displayEntities, boolean displayBosses, IWailaConfig.DisplayMode displayMode) {
                this.displayTooltip = displayTooltip;
                this.displayBlocks = displayBlocks;
                this.displayEntities = displayEntities;
                this.displayBosses = displayBosses;
                this.displayMode = displayMode;
            }

            public ConfigDisplay() {
            }

            public boolean shouldDisplayTooltip() {
                return this.displayTooltip;
            }

            public void setDisplayTooltip(boolean displayTooltip) {
                this.displayTooltip = displayTooltip;
            }

            public boolean getDisplayBlocks() {
                return this.displayBlocks;
            }

            public void setDisplayBlocks(boolean displayBlocks) {
                this.displayBlocks = displayBlocks;
            }

            public boolean getDisplayEntities() {
                return this.displayEntities;
            }

            public void setDisplayEntities(boolean displayEntities) {
                this.displayEntities = displayEntities;
            }

            public boolean getDisplayBosses() {
                return this.displayBosses;
            }

            public void setDisplayBosses(boolean displayBosses) {
                this.displayBosses = displayBosses;
            }

            public IWailaConfig.DisplayMode getDisplayMode() {
                return this.displayMode;
            }

            public void setDisplayMode(IWailaConfig.DisplayMode displayMode) {
                this.displayMode = displayMode;
            }
        }
    }

    public static class ConfigOverlay
    implements IWailaConfig.IConfigOverlay {
        public static final Codec<ConfigOverlay> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.fieldOf("activeTheme").orElse((Object)Theme.DARK.id).forGetter($ -> $.activeTheme), (App)Codec.INT.optionalFieldOf("themesHash", (Object)0).forGetter($ -> $.themesHash), (App)Codec.FLOAT.fieldOf("overlayPosX").orElse((Object)Float.valueOf(0.5f)).forGetter(ConfigOverlay::getOverlayPosX), (App)Codec.FLOAT.fieldOf("overlayPosY").orElse((Object)Float.valueOf(1.0f)).forGetter(ConfigOverlay::getOverlayPosY), (App)Codec.floatRange((float)0.2f, (float)2.0f).fieldOf("overlayScale").orElse((Object)Float.valueOf(1.0f)).forGetter(ConfigOverlay::getOverlayScale), (App)Codec.FLOAT.fieldOf("overlayAnchorX").orElse((Object)Float.valueOf(0.5f)).forGetter(ConfigOverlay::getAnchorX), (App)Codec.FLOAT.fieldOf("overlayAnchorY").orElse((Object)Float.valueOf(0.0f)).forGetter(ConfigOverlay::getAnchorY), (App)Codec.BOOL.fieldOf("overlaySquare").orElse((Object)false).forGetter(ConfigOverlay::getSquare), (App)Codec.BOOL.fieldOf("flipMainHand").orElse((Object)false).forGetter(ConfigOverlay::getFlipMainHand), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("autoScaleThreshold").orElse((Object)Float.valueOf(0.4f)).forGetter(ConfigOverlay::getAutoScaleThreshold), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("alpha").orElse((Object)Float.valueOf(0.7f)).forGetter(ConfigOverlay::getAlpha), (App)class_3542.method_28140(IWailaConfig.IconMode::values).fieldOf("iconMode").orElse((Object)IWailaConfig.IconMode.TOP).forGetter(ConfigOverlay::getIconMode), (App)Codec.BOOL.fieldOf("animation").orElse((Object)true).forGetter(ConfigOverlay::getAnimation), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("disappearingDelay").orElse((Object)Float.valueOf(0.0f)).forGetter(ConfigOverlay::getDisappearingDelay)).apply((Applicative)i, ConfigOverlay::new));
        public class_2960 activeTheme;
        public int themesHash;
        private float overlayPosX;
        private float overlayPosY;
        private float overlayScale;
        private float overlayAnchorX;
        private float overlayAnchorY;
        private boolean overlaySquare;
        private boolean flipMainHand;
        @Expose
        private float autoScaleThreshold;
        private float alpha;
        private transient Theme activeThemeInstance;
        private IWailaConfig.IconMode iconMode;
        private boolean animation;
        private float disappearingDelay;

        public ConfigOverlay() {
            this.activeTheme = Theme.DARK.id;
            this.overlayPosX = 0.5f;
            this.overlayPosY = 1.0f;
            this.overlayScale = 1.0f;
            this.overlayAnchorX = 0.5f;
            this.overlayAnchorY = 0.0f;
            this.overlaySquare = false;
            this.flipMainHand = false;
            this.autoScaleThreshold = 0.4f;
            this.alpha = 0.7f;
            this.iconMode = IWailaConfig.IconMode.TOP;
            this.animation = true;
        }

        public ConfigOverlay(class_2960 activeTheme, int themesHash, float overlayPosX, float overlayPosY, float overlayScale, float overlayAnchorX, float overlayAnchorY, boolean overlaySquare, boolean flipMainHand, float autoScaleThreshold, float alpha, IWailaConfig.IconMode iconMode, boolean animation, float disappearingDelay) {
            this.activeTheme = Theme.DARK.id;
            this.overlayPosX = 0.5f;
            this.overlayPosY = 1.0f;
            this.overlayScale = 1.0f;
            this.overlayAnchorX = 0.5f;
            this.overlayAnchorY = 0.0f;
            this.overlaySquare = false;
            this.flipMainHand = false;
            this.autoScaleThreshold = 0.4f;
            this.alpha = 0.7f;
            this.iconMode = IWailaConfig.IconMode.TOP;
            this.animation = true;
            this.activeTheme = activeTheme;
            this.themesHash = themesHash;
            this.overlayPosX = overlayPosX;
            this.overlayPosY = overlayPosY;
            this.overlayScale = overlayScale;
            this.overlayAnchorX = overlayAnchorX;
            this.overlayAnchorY = overlayAnchorY;
            this.overlaySquare = overlaySquare;
            this.flipMainHand = flipMainHand;
            this.autoScaleThreshold = autoScaleThreshold;
            this.alpha = alpha;
            this.iconMode = iconMode;
            this.animation = animation;
            this.disappearingDelay = disappearingDelay;
        }

        @Override
        public float getOverlayPosX() {
            return class_3532.method_15363((float)this.overlayPosX, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setOverlayPosX(float overlayPosX) {
            this.overlayPosX = class_3532.method_15363((float)overlayPosX, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getOverlayPosY() {
            return class_3532.method_15363((float)this.overlayPosY, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setOverlayPosY(float overlayPosY) {
            this.overlayPosY = class_3532.method_15363((float)overlayPosY, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getOverlayScale() {
            return this.overlayScale;
        }

        @Override
        public void setOverlayScale(float overlayScale) {
            this.overlayScale = class_3532.method_15363((float)overlayScale, (float)0.2f, (float)2.0f);
        }

        @Override
        public float getAnchorX() {
            return class_3532.method_15363((float)this.overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setAnchorX(float overlayAnchorX) {
            this.overlayAnchorX = class_3532.method_15363((float)overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getAnchorY() {
            return class_3532.method_15363((float)this.overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setAnchorY(float overlayAnchorY) {
            this.overlayAnchorY = class_3532.method_15363((float)overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        @Override
        public boolean getFlipMainHand() {
            return this.flipMainHand;
        }

        @Override
        public void setFlipMainHand(boolean overlaySquare) {
            this.flipMainHand = overlaySquare;
        }

        @Override
        public float tryFlip(float f) {
            if (this.flipMainHand && class_310.method_1551().field_1690.method_42552().method_41753() == class_1306.field_6182) {
                f = 1.0f - f;
            }
            return f;
        }

        @Override
        public boolean getSquare() {
            return this.overlaySquare;
        }

        @Override
        public void setSquare(boolean overlaySquare) {
            this.overlaySquare = overlaySquare;
        }

        @Override
        public float getAutoScaleThreshold() {
            return this.autoScaleThreshold;
        }

        @Override
        public float getAlpha() {
            return this.alpha;
        }

        @Override
        public void setAlpha(float alpha) {
            this.alpha = class_3532.method_15363((float)alpha, (float)0.0f, (float)1.0f);
        }

        @Override
        public Theme getTheme() {
            if (this.activeThemeInstance == null) {
                this.applyTheme(this.activeTheme);
            }
            return this.activeThemeInstance;
        }

        @Override
        @Deprecated
        public Collection<Theme> getThemes() {
            return IThemeHelper.get().getThemes();
        }

        @Override
        public void applyTheme(class_2960 id) {
            this.activeThemeInstance = IThemeHelper.get().getTheme(id);
            this.activeTheme = this.activeThemeInstance.id;
            BoxStyle.DEFAULT.borderColor = this.activeThemeInstance.boxBorderColor;
        }

        @Override
        public IWailaConfig.IconMode getIconMode() {
            return this.iconMode;
        }

        @Override
        public void setIconMode(IWailaConfig.IconMode iconMode) {
            this.iconMode = iconMode;
        }

        @Override
        public boolean shouldShowIcon() {
            return this.iconMode != IWailaConfig.IconMode.HIDE;
        }

        @Override
        public boolean getAnimation() {
            return this.animation;
        }

        @Override
        public void setAnimation(boolean animation) {
            this.animation = animation;
        }

        @Override
        public void setDisappearingDelay(float delay) {
            this.disappearingDelay = delay;
        }

        @Override
        public float getDisappearingDelay() {
            return this.disappearingDelay;
        }
    }

    public static class ConfigFormatting
    implements IWailaConfig.IConfigFormatting {
        public static final Codec<ConfigFormatting> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("modName").orElse((Object)"\u00a79\u00a7o%s").forGetter(ConfigFormatting::getModName)).apply((Applicative)i, ConfigFormatting::new));
        private String modName = "\u00a79\u00a7o%s";

        public ConfigFormatting(String modName) {
            this.modName = modName;
        }

        public ConfigFormatting() {
        }

        @Override
        public String getModName() {
            return this.modName;
        }

        @Override
        public void setModName(String modName) {
            this.modName = modName;
        }

        @Override
        @Deprecated
        public class_2561 title(Object title) {
            return IThemeHelper.get().title(title);
        }

        @Override
        public class_2561 registryName(String name) {
            return class_2561.method_43470((String)name).method_27692(IThemeHelper.get().isLightColorScheme() ? class_124.field_1063 : class_124.field_1080);
        }
    }
}

